using UnityEngine;
using System.Collections;
[System.Serializable]

public class Menu : MonoBehaviour
{
	public enum STATES
	{
		INVALID,
		MENU,
		LOADING_IN_PROGRESS,
		INSTRUCTION,
		PLAY,
		OPTION,
		PERDU,
		CHOIX_DIFFICULTE,
		GAGNE,
		HIGHSCORE

	};

	public GameObject loadingGameObject;
	public GameObject sceneGameObject;

	public static Menu instance;
	private bool zoneDetexte=false;
	public STATES state = STATES.MENU;

	float timer;
	int timerInt;
	int compteurPoint;
	int compteurCoup;
	int tempsTotal;

	public Texture2D instruction;
	public Texture2D highscore;
	public Texture2D menu;
	public Texture2D option;
	public Texture2D CHlevel;
	public Texture2D loose;
	public Texture2D win;
	
	public GUIStyle styleLevel;
	public GUIStyle styleSound;
	public GUIStyle styleClic;
	public GUIStyle load;
	public GUIStyle Gaming;
	public GUIStyle Loose;
	public GUIStyle Win;
	public GUIStyle ChoixLevel;
	public GUIStyle SelectLevel;
	public GUIStyle Valider;
	public GUIStyle alpha;
	
	public GUIStyle label;
	public GUIStyle Back;

	public AudioSource menuMusic;
	public AudioSource playMusic;
	public AudioSource looseMusic;
	public AudioSource winMusic;

	 string[] highscoreName ;
	 int[] highscoreScore ;

	public Items items;
	public Levels levels;

	public string difficult;
	string nomJoueur = "";
		
	bool SonMute; 
	


	// Use this for initialization
	void Start () 
	{
		instance = this;
		levels = GetComponent<Levels>();
		timer = 130;
		compteurPoint = 0;

		highscoreName = new string [5] {"toto", "titi", "tonton", "tutu", "tata"};
		highscoreScore = new int [5]{ 200,150,100,50,10};
		stringToEdit = "";
		menuMusic.Play();

		playMusic.mute = true;


	}
	
	// Update is called once per frame
	void Update () 
	{
	

	}

	// permet de travailler sur la taille du rectangle choisi, peu importe la resolution de l'appareil finale

	static public Rect MyRect (float x, float y, float size_x, float size_y)
	{
		return new Rect ( x *Screen.width/800, y *Screen.height/480, size_x*Screen.width/800, size_y*Screen.height/480	);
	}
	
	void OnGUI()
	{
		switch (state)
		{
			case STATES.INVALID: 
			break;	

			case STATES.PERDU: // on crée notre menu principal
			{
				sceneGameObject.gameObject.SetActive(false);
			GUI.DrawTexture (new Rect(0,0,Screen.width,Screen.height),loose);
				GUI.Label(new Rect(175, 180, 150, 60), "YOU LOOSE...", Loose);
				HighScoreGame ();
			levels.Clear ();
			Items.score=0;
			Items.nombreCoup=0;

				if ( SonMute ==true)
				{
				playMusic.Stop();
				menuMusic.Stop();
				looseMusic.Stop();
				}
				else
				{
				playMusic.Stop();
				menuMusic.Stop();
				looseMusic.Play();
				}
				
				break;
			}
			case STATES.GAGNE : // on crée notre menu principal
			{
				sceneGameObject.gameObject.SetActive(false);
				GUI.DrawTexture (new Rect(0,0,Screen.width,Screen.height),win);
				GUI.Label(new Rect(175, 180, 150, 60), "YOU WIN !!!", Win);
				HighScoreGame ();

				playMusic.Stop();
				menuMusic.Stop();
				winMusic.Play ();

			levels.Clear ();
			Items.score=0;
			Items.nombreCoup=0;
					
				break;
			}
			
			case STATES.MENU: // on crée notre menu principal
			{
			GUI.DrawTexture (new Rect(0,0,Screen.width,Screen.height),menu);

			playMusic.mute= true;
	
			sceneGameObject.gameObject.SetActive(false);
			if (GUI.Button(new Rect(160, 266, 135, 35), "New Game",styleLevel))
					{
						state = STATES.CHOIX_DIFFICULTE;
					}
			
			if (GUI.Button(new Rect(160,366, 135, 35), "Settings",styleLevel))
					{
					state = STATES.OPTION;
					}
			if (GUI.Button(new Rect(160, 466, 135, 35), "Quit",styleLevel))
					{
					Application.Quit();
					}			
				break;
			}

			case STATES.CHOIX_DIFFICULTE:
			{
			GUI.DrawTexture (new Rect(0,0,Screen.width,Screen.height),CHlevel);
			GUI.Label(new Rect(160, 266, 150, 30), "Select your name :" , label);
			GUI.Label(new Rect(55, 166, 150, 30), "Select your Level" , SelectLevel);
			GUI.Label(new Rect(160, 400, 150, 30), "Select your Difficulty :" , label);

				if (GUI.Button(new Rect(0,0, 100, 45), "Back",Back))
				{
					state = STATES.MENU;		
				}
			if(zoneDetexte==false)
			{

				ZoneTexte ();
			}

				if (GUI.Button(new Rect(80, 500, 95, 50), "Easy",styleLevel))
				{
					difficult="facile";
					levels.CreateLevel(difficult);
					timer =  100;
					state=STATES.LOADING_IN_PROGRESS;
				}
				if (GUI.Button(new Rect(200, 500, 95, 50), "Medium",styleLevel))
				{
					difficult="moyen";
					levels.CreateLevel(difficult);
					timer =  150;
					state=STATES.LOADING_IN_PROGRESS;
				}
				if (GUI.Button(new Rect(320, 500, 95, 50), "Hard",styleLevel))
				{
					difficult="difficile";
					levels.CreateLevel(difficult);
					timer =  200;
					state=STATES.LOADING_IN_PROGRESS;
				}
				if (GUI.Button(new Rect(190, 600, 95, 50),"Valider",Valider))
				{
				    if (stringToEdit =="" ||difficult =="")
						{
							stringToEdit ="Joueur1";
							difficult = "facile";
						}
						else
						{
							stringToEdit = nomJoueur ;
							Debug.Log(stringToEdit);
							Debug.Log(nomJoueur);
							Debug.Log(difficult);
							state = STATES.LOADING_IN_PROGRESS;
						}
				}
			break;
		}
			
			case STATES.LOADING_IN_PROGRESS:
			{
				StartCoroutine(MyCoroutine());
				
				loadingGameObject.gameObject.SetActive(true); // passer Go en false, a la sortie de Loading in progress
				
				GUI.Label(new Rect(250,700, 400, 300), "Loading In Progress...",load);
				
				if (SonMute== true)
				{
					playMusic.Stop();
					menuMusic.Stop();
				}
				else
			{
					playMusic.mute=false;
					menuMusic.Stop();
				}
				break;
			}

			case STATES.OPTION:
			{	
			GUI.DrawTexture (new Rect(0,0,Screen.width,Screen.height),option);		
			if (GUI.Button(new Rect(0,0, 100, 45), "Back",Back))
					{
						state = STATES.MENU;		
					}
				
			if (GUI.Button(new Rect(160, 266, 135, 35), "HighScore",styleLevel))
					{
						state= STATES.HIGHSCORE;
					}
				
			if (GUI.Button(new Rect(160,366, 135, 35), "Sound",styleSound))
					{ 

					if (audio.mute)
						{
						audio.mute = false;
						SonMute = false;
						Debug.Log ("mute");
						}	
						else
							audio.mute = true;
							SonMute = true;
					}
			if (GUI.Button(new Rect(160, 466, 135, 35), "Tutorial",styleLevel))
					{
						state = STATES.INSTRUCTION;
					}			
				break;
				}
				
				case STATES.INSTRUCTION:
				{		
							GUI.DrawTexture (new Rect(0,0,Screen.width,Screen.height),instruction);
								//Texte qui clignotte
							if(Time.time%1.5f<0.75f)
							{
								GUI.Label( new Rect (150,Screen.height*0.85f-25,200,50),"Clic to pass ...", styleClic);						
							}
								//Bouton de la taille de l'écran pour passer a la scène suivante
							if(GUI.Button(new Rect(0,0,Screen.width,Screen.height), "",alpha))
							{	
							 state = STATES.OPTION;		
							}

				break;
				}

				case STATES.PLAY: 
				{
					loadingGameObject.gameObject.SetActive(false); // passer Go en false, a la sortie de Loading in progress
					sceneGameObject.gameObject.SetActive(true);
					if (GUI.Button(new Rect(0,0, 100, 45), "Back",Back))
					{
						state = STATES.MENU;		
					}
					timer -= Time.deltaTime ;
					timerInt = (int) timer;
			compteurPoint=Items.score;

					GUI.Label(new Rect(120,35, 150, 60), "Temps restant :" + timerInt , Gaming);
					
					GUI.Label(new Rect(250, 35, 150, 60), "Points :" + Items.score, Gaming);
					
			if((Items.score==40 && difficult=="facile")||(Items.score==80 && difficult=="moyen")||(Items.score==100 && difficult=="difficile"))
			{
				state=STATES.GAGNE;
			}

					if(timer < 0)
					{
						state = STATES.PERDU ;
						
					}
					break;
				}

				case STATES.HIGHSCORE:
				{
					GUI.DrawTexture (new Rect(0,0,Screen.width,Screen.height),highscore);
					GUI.Label(new Rect(100, 200, 150, 60), "HIGHSCORE" , ChoixLevel);
					GUI.Label(new Rect(85, 360, 150, 60), "Name" , label);
					GUI.Label(new Rect(250, 360, 150, 60), "Score" , label);
					int i;

					for ( i = 0; i < 5 ; i++)
					{
				if (compteurPoint > highscoreScore [i])
				{
					int tempoPoint;
					string tempoNom;
					tempoPoint=highscoreScore[i];
					tempoNom=highscoreName[i];
					
					highscoreScore [i] = compteurPoint ;
					highscoreName[i] = nomJoueur ;
					
					compteurPoint=tempoPoint;
					nomJoueur=tempoNom;
				}
					
					GUI.Label(new Rect(135, 435 + i*50.0f, 400, 50), ""+ highscoreName[i]);
					GUI.Label(new Rect(320, 435 + i*50.0f, 400, 50), ""+ highscoreScore[i]);
					}

				if (GUI.Button(new Rect(0,0, 110, 45), "Back",Back))
					{
						state = STATES.OPTION;		
					}

				break;
				}
		}
	}

	IEnumerator  MyCoroutine()
	{
		float counter = 0;
		loadingGameObject.gameObject.SetActive(true); // passer Go en false, a la sortie de Loading in progress
		while (counter < 3f) 
		{
			counter+= Time.deltaTime;
			yield return 0;
		}	

		state = STATES.PLAY ;
		yield return 0;
	}

	void HighScoreGame ()
	{
		GUI.Label(new Rect(160, 266, 150, 60), "Your score : " + compteurPoint , label);

		//GUI.Label(new Rect(160,366, 150, 60), "Performed in " + compteurCoup + " try", label);

		GUI.Label(new Rect(160, 466, 150, 60), " Time left : " + timerInt + "sec" , label);

		if (GUI.Button (new Rect (100, 566, 120, 40), "Retry", styleLevel)) 
		{
			state = STATES.CHOIX_DIFFICULTE ;	
		}
		
		if (GUI.Button (new Rect (270, 566, 120, 40), "Quit", styleLevel)) 
		{
			state = STATES.MENU ;	
		}
	}

	static string stringToEdit = ""; // zone de texte
	private TouchScreenKeyboard keyboard;

	void ZoneTexte ()
	{
		zoneDetexte = true;
		stringToEdit = GUI.TextField(new Rect(140,350, 200, 30), stringToEdit, 10);
		keyboard = TouchScreenKeyboard.Open(stringToEdit, TouchScreenKeyboardType.Default);
		
		if (keyboard.done)
		{
			print ("" + stringToEdit);
			stringToEdit = keyboard.text;
		}
		
	}

	IEnumerator  MyCoroutineHG()
	{
		float counter = 0;
		while (counter < 7f) 
		{
			counter+= Time.deltaTime;
			yield return 0;
		}	
		state = STATES.HIGHSCORE ;
		yield return 0;
	}

}
